package com.vmware.samples.globalview.views {

import com.vmware.flexutil.events.MethodReturnEvent;
import com.vmware.samples.globalview.GlobalServiceProxy;
import com.vmware.samples.globalview.GlobalSettings;
import com.vmware.ui.events.NavigationRequest;

import flash.events.EventDispatcher;
import flash.events.MouseEvent;

import mx.controls.Alert;
import mx.rpc.Fault;

[Event(name="{com.vmware.ui.events.NavigationRequest.NAVIGATION_REQUEST}",
      type="com.vmware.ui.events.NavigationRequest")]
/**
 * Class implementing the SettingView logic
 */
public class SettingViewMediator extends EventDispatcher {
   // Main view's extendion id (defined in plugin.xml)
   private static const APPVIEW_ID:String = "com.vmware.samples.globalviewui.appview";
   private var _view:SettingView;

   // Define a global proxy instance with the InjectableProxy tag
   [InjectableProxy]
   public var proxy:GlobalServiceProxy;

   [View]
   /** The view associated with this mediator. */
   public function set view(value:SettingView):void {
      // The view is injected here by the Framework when it is first created,
      // and reset to null when it is no longer needed.
      if ((value == null) && (_view != null)) {
         _view.updateButton.removeEventListener(MouseEvent.CLICK, onUpdateClick);
         _view.linkButton.removeEventListener(MouseEvent.CLICK, onLinkButtonClick);
      }

      _view = value;
      if (_view != null) {
         initialize();
      }
   }

   public function get view():SettingView {
      return _view;
   }

   private function initialize():void {
      _view.updateButton.addEventListener(MouseEvent.CLICK, onUpdateClick);
      _view.linkButton.addEventListener(MouseEvent.CLICK, onLinkButtonClick);

      // The update button will be enabled only when a text input changes
      _view.updateButton.enabled = false;

      // Async call to retrieve the settings data from the back-end
      proxy.getSettings(onGetSettingsResult);
   }

   /**
    * Callback from the GlobalService getSettings method.
    */
   private function onGetSettingsResult(event:MethodReturnEvent):void {
      if (event.error != null) {
         Alert.show("Error getting settings: " + event.error.message);
         return;
      }
      _view.settings = event.result as GlobalSettings;
      _view.setSelectedEnum(_view.settings.setting3);
   }

   private function onUpdateClick(click:MouseEvent):void {
      _view.settings.setting1 = _view.setting1.text;
      _view.settings.setting2 = _view.setting2.text;
      _view.settings.setting3 = _view.getSelectedEnum();

      // Async call to update settings on the back-end,
      proxy.setSettings(_view.settings, onSetSettingsResult);

      _view.updateButton.enabled = false;
   }

   private function onLinkButtonClick(click:MouseEvent):void {
      // Jump to the main App view
      var event:NavigationRequest = new NavigationRequest();
      event.targetViewUid = APPVIEW_ID;
      dispatchEvent(event);
   }

   /**
    * Callback from the GlobalService setSettings method.
    */
   private function onSetSettingsResult(event:MethodReturnEvent):void {
      if (event.error != null) {
         // Default error message
         var errorMsg:String = event.error.message;

         // In case of an RPC Fault the faultCode is set to the initial Java exception
         // by our custom ExceptionTranslatorService, so we can handle specific errors
         // like FileNotFoundException.
         if (event.error is Fault) {
            var faultCode:String = (event.error as Fault).faultCode;
            var faultDetails:String = (event.error as Fault).faultDetail;
            if (faultCode == "java.io.FileNotFoundException") {
               errorMsg = faultDetails +
                  "\n\nCheck that the server process has write access to the file.";
            } else {
               errorMsg = faultCode + ": " + faultDetails;
            }
         }
         Alert.show("Error saving settings: " + errorMsg);
         return;
      }
      // Update the status label to confirm action to the user.
      _view.updateStatus.text = "Settings were updated.";
   }
}
}